/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.world.mayor;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.config.world.MayorHouseGeneratorConfig;
import dev.toma.gunsrpg.world.mayor.VillageVariantEntry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;

public final class VillageFeatureMutator {
    private static final Map<String, List<VillageVariantEntry>> VARIANTS = (Map)Util.func_200696_a(new HashMap(), map -> {
        VillageFeatureMutator.registerSingleVariant(map, "desert", MayorHouseGeneratorConfig::getDesertWeight);
        VillageFeatureMutator.registerSingleVariant(map, "savanna", MayorHouseGeneratorConfig::getSavannaWeight);
        VillageFeatureMutator.registerSingleVariant(map, "snowy", MayorHouseGeneratorConfig::getSnowyWeight);
        VillageFeatureMutator.registerSingleVariant(map, "plains", MayorHouseGeneratorConfig::getPlainsWeight);
        VillageFeatureMutator.registerSingleVariant(map, "taiga", MayorHouseGeneratorConfig::getTaigaWeight);
    });

    public static void mutateVanillaVillages() {
        for (List<VillageVariantEntry> list : VARIANTS.values()) {
            VillageFeatureMutator.addMayorStructures(list);
        }
    }

    public static void addMayorStructures(List<VillageVariantEntry> list) {
        for (VillageVariantEntry entry : list) {
            VillageFeatureMutator.addMayorStructure(entry);
        }
    }

    private static void addMayorStructure(VillageVariantEntry entry) {
        ResourceLocation key = new ResourceLocation(entry.getTargetVariant());
        JigsawPattern pattern = (JigsawPattern)WorldGenRegistries.field_243656_h.func_82594_a(key);
        pattern.field_214953_e.clear();
        Pair pair = Pair.of((Object)JigsawPiece.func_242849_a((String)entry.getResourcePath()), (Object)entry.getCount());
        JigsawPiece piece = (JigsawPiece)((Function)pair.getFirst()).apply(JigsawPattern.PlacementBehaviour.RIGID);
        pattern.field_214952_d = ImmutableList.builder().addAll((Iterable)pattern.field_214952_d).add((Object)Pair.of((Object)piece, (Object)pair.getSecond())).build();
        pattern.field_214952_d.forEach(rawTemplate -> {
            JigsawPiece jigsawPiece = (JigsawPiece)rawTemplate.getFirst();
            for (int i = 0; i < (Integer)rawTemplate.getSecond(); ++i) {
                pattern.field_214953_e.add(jigsawPiece);
            }
        });
    }

    private static void registerSingleVariant(Map<String, List<VillageVariantEntry>> map, String variant, ToIntFunction<MayorHouseGeneratorConfig> func) {
        MayorHouseGeneratorConfig cfg = GunsRPG.config.world.generationConfig.mayorHouseGen;
        String templatePool = "village/" + variant + "/houses";
        VillageVariantEntry entry = new VillageVariantEntry(templatePool, templatePool + "/mayor_home", func.applyAsInt(cfg));
        ImmutableList list = ImmutableList.of((Object)entry);
        map.put(variant, (List<VillageVariantEntry>)list);
    }
}

